/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import java.util.HashMap;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;
import technology.rocketjump.undermount.mapgen.generators.GameMapGenerator;
import technology.rocketjump.undermount.mapgen.model.input.GameMapGenerationParams;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.input.RockType;
import technology.rocketjump.undermount.mapgen.model.input.ShrubType;
import technology.rocketjump.undermount.mapgen.model.input.TreeType;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;

public class MapGenWrapper {
    private final GameMaterialDictionary materialDictionary;
    private final PlantSpeciesDictionary plantSpeciesDictionary;

    @Inject
    public MapGenWrapper(GameMaterialDictionary materialDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.materialDictionary = materialDictionary;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
    }

    public GameMap createUsingLibrary(long worldSeed, int worldWidth, int worldHeight) {
        System.out.println("Generating map with seed: " + worldSeed);
        long startTime = System.currentTimeMillis();
        GameMapGenerationParams generationParams = this.createMapGenerationParams(worldWidth, worldHeight);
        RandomXS128 random = new RandomXS128(worldSeed);
        GameMapGenerator generator = new GameMapGenerator(generationParams, random);
        GameMap mapGenGameMap = generator.completeGeneration();
        long endTime = System.currentTimeMillis();
        System.out.println("Took " + (endTime - startTime) + "ms");
        return mapGenGameMap;
    }

    private GameMapGenerationParams createMapGenerationParams(int width, int height) {
        HashMap<String, OreType> oreNameMap = new HashMap<String, OreType>();
        for (GameMaterial oreMaterial : this.materialDictionary.getByType(GameMaterialType.ORE)) {
            oreNameMap.put(oreMaterial.getMaterialName(), new OreType(oreMaterial.getMaterialName(), oreMaterial.getColor(), oreMaterial.getPrevalence().floatValue()));
        }
        GameMapGenerationParams generationParams = new GameMapGenerationParams(width, height);
        for (GameMaterial rockMaterial : this.materialDictionary.getByType(GameMaterialType.STONE)) {
            RockType rockType = new RockType(rockMaterial.getRockGroup(), rockMaterial.getMaterialName(), rockMaterial.getColor(), rockMaterial.getPrevalence().floatValue());
            for (String oreName : rockMaterial.getOreNames()) {
                OreType oreType = (OreType)oreNameMap.get(oreName);
                if (oreType == null) {
                    System.out.println("Could not find ore with name " + oreName + " for " + rockMaterial.getMaterialName());
                    continue;
                }
                rockType.addOreType(oreType);
            }
            generationParams.addRockTypes(rockType);
        }
        for (GameMaterial gemMaterial : this.materialDictionary.getByType(GameMaterialType.GEM)) {
            GemType gemType = new GemType(gemMaterial.getRockGroup(), gemMaterial.getMaterialName(), gemMaterial.getColor(), gemMaterial.getPrevalence().floatValue());
            generationParams.addGemTypes(gemType);
        }
        for (PlantSpecies treeSpecies : this.plantSpeciesDictionary.getBySpeciesType(PlantSpeciesType.TREE)) {
            TreeType treeType = new TreeType(treeSpecies.getSpeciesName());
            if (treeSpecies.isEvergreen()) {
                treeType.setMinYPosition(0.7f);
            } else {
                treeType.setMaxYPosition(0.8f);
            }
            generationParams.getTreeTypes().add(treeType);
        }
        for (PlantSpecies shrubSpecies : this.plantSpeciesDictionary.getBySpeciesType(PlantSpeciesType.SHRUB)) {
            generationParams.getShrubTypes().add(new ShrubType(shrubSpecies.getSpeciesName(), shrubSpecies.getFruit() != null));
        }
        return generationParams;
    }
}

